import { notFound } from 'next/navigation';
import { templates } from '@/lib/templates';
import BuilderClient from './client';

export function generateStaticParams() {
    return templates.map((t) => ({ id: t.id }));
}

export default async function BuilderPage({ params }: { params: Promise<{ id: string }> }) {
    const { id } = await params;
    const template = templates.find((t) => t.id === id);

    if (!template) {
        notFound();
    }

    return <BuilderClient template={template} />;
}
